//OHSAT GAMES TUTORIAL: MEGALAGA 2 BONUS: Entities + 1
//MEGATEAMWORK Makes the MEGADREAM Work 

//https://www.ohsat.com/tutorial/#mega-drive-tutorials 

#include <genesis.h>
#include <resources.h>

// Declarations
int offset = 0;

typedef struct {
	int x;
	int y;
	int w;
	int h;
	int velx;
	int vely;
	int health;
	Sprite* sprite;
	char name[8];
} Entity;

Entity player = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER" };
Entity player_2 = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER 2" };

void killEntity(Entity* e);
void reviveEntity(Entity* e);

int main()
{
    SYS_disableInts();
    VDP_loadTileSet(background.tileset, 1, DMA);  // Load tile set at index 1
    PAL_setPalette(PAL1, background.palette->data, DMA);  // Set palette
    VDP_setScrollingMode(HSCROLL_PLANE, VSCROLL_PLANE);
    SYS_enableInts();

    SPR_init();

    /*Add the player*/
    player.x = 152;
    player.y = 192;
    player.health = 1;
    player.sprite = SPR_addSprite(&ship, player.x,player.y,TILE_ATTR(PAL1,0,FALSE,FALSE));

        /*Add the player 2*/
    player_2.x = 100;
    player_2.y = 192;
    player_2.health = 1;
    player_2.sprite = SPR_addSprite(&ship1, player_2.x,player_2.y,TILE_ATTR(PAL1,0,FALSE,FALSE));
    SPR_update();

    int i = 0;
    int thex = 0;
    int they = 0;
    int val = 1;

    // Fill the background with random tiles
    for (int i = 0; i < 1280; i++)  // 40x32 = full screen + buffer
    {
        int thex = i % 40;
        int they = i / 40;

        // Randomly choose between blank (0), star1 (1), or star2 (2)
        int val = (random() % (10 - 1 + 1)) + 1;  // 0, 1, or 2
        if(val > 3) val = 1;
        VDP_setTileMapXY(BG_B, TILE_ATTR_FULL(PAL1, 0, 0, 0, val), thex, they);
    }

    while (1)
    {
        // Scroll the background vertically
        VDP_setVerticalScroll(BG_B, offset -= 2);
        if (offset <= -256) offset = 0;

        SPR_update();
        SYS_doVBlankProcess();
    }

    return 0;
}

//////Functions///////

void killEntity(Entity* e){
	e->health = 0;
	SPR_setVisibility(e->sprite,HIDDEN);
}

void reviveEntity(Entity* e){
	e->health = 1;
	SPR_setVisibility(e->sprite,VISIBLE);
}

////////////////////NOTES////////////////////

/*

I've added a palette swapped sprite called imgship1.bmp in the Sprites folder. 

We need to add it to the Resources.res file. 

SPRITE  ship1 "sprites/imgship1.bmp" 2 2 FAST 6

Once that is updated, we're essentially just going to copy the code for the player ship and make small
changes to identifiers and X-position so that the ships don't overlap. 

Entity player = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER" };
Entity player_2 = {0, 0, 16, 16, 0, 0, 0, NULL, "PLAYER 2" };

     //Add the player 2//
    player_2.x = 100;
    player_2.y = 192;
    player_2.health = 1;
    player_2.sprite = SPR_addSprite(&ship1, player_2.x,player_2.y,TILE_ATTR(PAL1,0,FALSE,FALSE));

We also updated the char array from six characters to 8 since PLAYER 2 is eight characters instead of six. 

char name[8

*/

/////////EXPERIMENTATION IDEAS///////////////

/*

Let's add a second ship for potential 2-player co-op. 

*/

///////////ERROR HANDLING////////////////////
/*

*/